﻿var importExport = {
    context: $(".v-import, .v-export"),
    importContext: $(".v-import"),
    exportContext: $(".v-export"),
    initializeAutoCompletes: function () {
        $(".h-languagesAutocomplete", this.context).a4autocomplete({
            ajaxAction: a4.getSurveyAction("GetQuestionnaireLanguagesForAutoComplete", "Questionnaire"),
            select: function (event, data) {
                if (data && data.item) {
                    var container = $(this).closest(".v-languagesContainer");
                    $(".v-selectedLanguages", container).val(_.pluck($(this).a4autocomplete("getValue"), "Value"));
                }
            },
            removeItem: function (event, data) {
                var container = $(this).closest(".v-languagesContainer");
                $(".v-selectedLanguages", container).val(_.pluck($(this).a4autocomplete("getValue"), "Value"));
            },
            multipleSelection: true
        });
    },
    bindEvents: function () {
        this.importContext.on("click", ".h-clearJson", function () {
            $(".h-fileUpload", importExport.context).prop("disabled", false);
        });

        this.importContext.on("click", ".h-clearFile", function () {
            var container = $(this).closest(".v-section");
            var fileUploadInput = $(".h-fileUpload", container);

            fileUploadInput.replaceWith($("<input />", { "type": "file", "id": fileUploadInput.attr("id"), "name": fileUploadInput.attr("name"), "class": fileUploadInput.attr("class"), "style": fileUploadInput.attr("style") }));

            $(this).hide();
            $(".v-sectionOptions", container).hide();

            var filesToUpload = _.compact($(".h-fileUpload:not('.h-jsonUpload')", importExport.context).map(function () { return $(this).val(); }).toArray());
            if (filesToUpload.length === 0) {
                $(".h-fileUpload", importExport.context).prop("disabled", false);
            }
        });

        this.importContext.on("change", ".h-jsonUpload", function () {
            if ($(this).val().length !== 0)
                $(".h-fileUpload:not('.h-jsonUpload')", importExport.context).prop("disabled", true);
        });

        this.importContext.on("change", ".h-fileUpload:not('.h-jsonUpload')", function () {
            if ($(this).val().length !== 0)
                $(".h-jsonUpload", importExport.context).prop("disabled", true);
        });

        this.importContext.on("change", ".h-fileUpload", function () {
            if ($(this).val().length !== 0) {
                var container = $(this).closest(".v-section");
                $(".v-importResult", container).hide();
                $(".h-clearFile", container).show();
                $(".v-sectionOptions", container).show();
            }
        });

        this.exportContext.on("change", "#TranslationOptions", function () {
            var container = $(this).closest(".content");
            $(".v-sectionOptions", container).toggle($(this).val() === "Selected");
        });
    }
}

$(document).ready(function () {
    importExport.initializeAutoCompletes();
    importExport.bindEvents();
});